#version 330
#extension GL_EXT_gpu_shader4 : enable
// Kaleidoscope of rotating squaresMod01.fsh  by   jblanper

//https://www.shadertoy.com/view/3lB3RW
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec2 rotate(vec2 p, float a) {
  return p * mat2(cos(a), -sin(a), sin(a), cos(a));
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord ) 
{
  vec2 uv = (gl_FragCoord.xy - .5 * iResolution.xy) / iResolution.y;

  vec2 gv = fract(abs(uv) * 2.) - .5;
  vec2 id = floor(abs(uv) * 2.);
  float t = ((mod(id.x, 2.) == 0.) ? -1. : 1.) * iTime * .1;
  gv = rotate(gv, t);

  vec3 color = vec3(0.);

  float m = smoothstep(.34, .32, max(abs(gv.x), abs(gv.y))) +
    (smoothstep(.5, 0., length(gv))*1.1);

  float squares = cos(max(abs(gv.x), abs(gv.y)) * (80. * (sin(iTime * .2) * .4 + 1.)));
  float diamonds = cos(max(abs(gv.x+gv.y), abs(gv.y-gv.x)) * 50. - iTime);

  color += smoothstep(.1, .9, diamonds)*vec3(.35);
  color += mix(vec3(.2), vec3(.5), cos(length(uv)*150.*cos(gv.y) - iTime * 2.)) * .01;

  color = mix(color, vec3(.3, .4, .5), squares * m) * 1.2;
  color *= mix(color, vec3(.8, .4, .2), diamonds / m) * 2.;

  color += smoothstep(.1, .2, squares) * vec3(.3, .2, .8);
  color -= mix(vec3(0.), vec3(.8, .2, .3), smoothstep(.1, .12, diamonds * m)) * .5;

  color *= 1.-length(uv)*.6;

  gl_FragColor = vec4(color, 1.);
}